package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.resteasy.Date;
import org.jboss.resteasy.annotations.ClientResponseType;

import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;

/**
 */
@Path("/query")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface QueryProxy {

	@GET
	@ClientResponseType(entityType = ConfigurationItemIds.class)
	Response list(@QueryParam("typeName") String typeName, @QueryParam("archetype") boolean archetype, @QueryParam("page") long page,
	        @QueryParam("resultsPerPage") long resultPerPage, @QueryParam("property") List<PropertyValue> values, @QueryParam("parent") String parent,
	        @QueryParam("name") String name);

	/**
	 * Reads multiple repository objects.
	 * 
	 * @param ids
	 *            a comma-separated list of objects ids.
	 * @return a {@link com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos list of repository objects}
	 */
	@POST
	@Path("read-multiple")
	@ClientResponseType(entityType = ConfigurationItemDtos.class)
	Response readMultiple(ConfigurationItemIds configurationItemIds);

    @GET
    @Path("compare/{reference:.*}")
    @ClientResponseType(entityType = Comparison.class)
    Response compare(@PathParam("reference") String reference, @QueryParam("id") List<String> ids);

	@GET
	@Path("search")
	@ClientResponseType(entityType = ConfigurationItemIds.class)
	Response search(@QueryParam("typeName") String typeName, @QueryParam("before") Date date);
}
