package com.xebialabs.deployit.core.api.dto;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.common.collect.Lists;

@XmlRootElement(name = "configuration-item-ids")
public class ConfigurationItemIds extends AbstractDTO {

	private List<ConfigurationItemId> configurationItemIds;

	public ConfigurationItemIds() {
		this(Lists.<ConfigurationItemId>newArrayList());
	}

	public ConfigurationItemIds(List<ConfigurationItemId> configurationItemIds) {
		this.configurationItemIds = configurationItemIds;
	}

	@XmlElementWrapper(name = "ids")
	@XmlElement(name = "configuration-item-id")
	public List<ConfigurationItemId> getConfigurationItemIds() {
		return configurationItemIds;
	}

	public void setConfigurationItemIds(final List<ConfigurationItemId> configurationItemIds) {
		this.configurationItemIds = configurationItemIds;
	}
}
