package com.xebialabs.deployit.core.api.dto;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Iterator;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement
public class RolePermissions extends AbstractDTO {

	private List<RolePermission> rolePermissions = newArrayList();

	public RolePermissions() {
	}

	public RolePermissions(List<RolePermission> rolePermissions) {
		this.rolePermissions = rolePermissions;
	}

	@XmlElement
	public List<RolePermission> getRolePermissions() {
		return rolePermissions;
	}

	public void setRolePermissions(List<RolePermission> rolePermissions) {
		this.rolePermissions = rolePermissions;
	}

	public RolePermission get(final String role) {
		Iterable<RolePermission> filter = Iterables.filter(rolePermissions, new Predicate<RolePermission>() {
			@Override
			public boolean apply(RolePermission input) {
				return input.getRole().getName().equals(role);
			}
		});
		Iterator<RolePermission> iterator = filter.iterator();
		if (!iterator.hasNext()) {
			RolePermission e = new RolePermission(new Role(role), Lists.<String>newArrayList());
			rolePermissions.add(e);
			return e;
		}
		return iterator.next();
	}
}
