package com.xebialabs.deployit.core.api;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.ClientResponseType;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;


@Path("/export")
public interface ExportProxy {

	@GET
	@Path("tasks")
	@Produces({MediaType.APPLICATION_XML})
	@ClientResponseType(entityType = FullTaskInfos.class)
	Response getFullArchivedTasks();

	@GET
	@Path("taskrange")
	@Produces({MediaType.APPLICATION_XML})
	@ClientResponseType(entityType = FullTaskInfos.class)
	Response getFullArchivedTasksInDateRange(@QueryParam("begin") Date begin, @QueryParam("end") Date end);
}
