package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.Orchestrators;
import com.xebialabs.deployit.core.api.dto.Permissions;
import org.jboss.resteasy.annotations.ClientResponseType;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/referenceData")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface ReferenceDataProxy {

	@GET
	@Path("descriptors")
	@ClientResponseType(entityType = ConfigurationItemDescriptorList.class)
	Response list();

    @GET
    @Path("type/{type}")
    @ClientResponseType(entityType = ConfigurationItemDescriptorDto.class)
    Response find(@PathParam("type") String type);

	@GET
	@Path("permissions")
	@ClientResponseType(entityType = Permissions.class)
	Response permissionList();

	@GET
	@Path("orchestrators")
	@ClientResponseType(entityType = Orchestrators.class)
	Response orchestrators();
}
