package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement
public class RolePermission extends AbstractDTO {
	
	private Role role;

	private List<String> permissions = newArrayList();

	public RolePermission() {
	}

	public RolePermission(Role role, List<String> permissions) {
		this.role = role;
		this.permissions = permissions;
	}

	@XmlElement
	public Role getRole() {
		return role;
	}

	public void setRole(Role role) {
		this.role = role;
	}

	@XmlElement
	public List<String> getPermissions() {
		return permissions;
	}

	public void setPermissions(List<String> permissions) {
		this.permissions = permissions;
	}

	public void grant(String permission) {
		this.permissions.add(permission);
	}

	public void revoke(String permission) {
		this.permissions.remove(permission);
	}
}
