package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.engine.api.security.Role;

@Path("/internal/security")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface InternalSecurityProxy {

    @GET
    @Path("roles")
    List<Role> list();

    @GET
    @Path("roles/principals")
    List<RolePrincipals> readRolePrincipals();

    @POST
    @Path("roles/principals")
    void writeRolePrincipals(List<RolePrincipals> rolePrincipals);

    @GET
    @Path("roles/permissions/{id:.*?}")
    List<RolePermissions> readRolePermissions(@PathParam("id") String id);

    @POST
    @Path("roles/permissions/{id:.*?}")
    void writeRolePermissions(@PathParam("id") String id, List<RolePermissions> permissions);

}
