package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.deployit.engine.api.security.Role;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement
public class RolePrincipals extends AbstractDTO {
    
    private Role role;

    private List<String> principals = newArrayList();

    public RolePrincipals() {
    }

    public RolePrincipals(Role role, List<String> principals) {
        this.role = role;
        this.principals = principals;
    }

    @XmlElement
    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @XmlElement
    public List<String> getPrincipals() {
        return principals;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
    }
}
