package com.xebialabs.xlplatform.rest.script

import java.net.URL
import scala.xml.{XML, Elem}
import java.io.InputStream
import com.xebialabs.deployit.booter.local.utils.Closeables

object ResourceUtils {

  def findResources(filePattern: String): Seq[URL] = {
    import collection.convert.wrapAll._
    Thread.currentThread().getContextClassLoader.getResources(filePattern).toSeq
  }

  def loadXmlResources(filePattern: String): List[Elem] = {
    import com.xebialabs.platform.utils.ResourceManagement._
    findResources(filePattern).map {r =>
        map(r.openStream()) { s =>
          XML.load(s)
        }
    }.toList
  }

}
