package com.xebialabs.xlplatform.rest.script

import com.typesafe.config.Config
import akka.actor.{ExtensionIdProvider, ExtensionId, Extension, ExtendedActorSystem}

class Settings(config: Config, extendedSystem: ExtendedActorSystem) extends Extension {

  object XlDeploy {
    object UiExtension {
      val file = config.getString("xl-deploy.ui-extension.file")
    }
    object ServerExtension {
      val file = config.getString("xl-deploy.server-extension.file")
    }
  }
}

object Settings extends ExtensionId[Settings] with ExtensionIdProvider {
  override def lookup() = Settings
  override def createExtension(system: ExtendedActorSystem) = new Settings(system.settings.config, system)
}
