package com.xebialabs.xlplatform.rest.script.boot

import spray.servlet.WebBoot
import akka.actor._
import com.xebialabs.xlplatform.rest.script.endpoints.{ExtendableRestApi, ScriptEndpoints, ScriptExtensionRoute}
import spray.routing.{HttpServiceActor, HttpServiceBase}
import com.xebialabs.xlplatform.rest.script.Settings


class ApiActor extends HttpServiceActor with ExtendableRestApi {

  val settings: Settings = Settings(context.system)

  override def receive: Actor.Receive = {
    runRoute(extendableRoutes)
  }
}

class ServletBoot extends WebBoot {

  val system =  ActorSystem("extension-servlet-system")

  val serviceActor = system.actorOf(Props[ApiActor], "extension-rest-api")

}
