package com.xebialabs.xlplatform.rest.script.endpoints

import spray.routing._
import com.xebialabs.xlplatform.rest.script.Settings
import com.xebialabs.xlplatform.rest.script.jython.{ScriptDone, JythonScriptExecutorActor}
import akka.pattern.{AskTimeoutException, ask}
import akka.util.Timeout
import scala.concurrent.duration._
import spray.http._

import com.xebialabs.xlplatform.rest.script.endpoints.json.{ScriptResponse, ScriptResponseProtocol}
import spray.httpx.SprayJsonSupport
import akka.actor.ActorRef
import spray.json.{JsValue, JsNull}
import spray.http.HttpHeaders.RawHeader
import scala.util.Failure
import scala.Some
import com.xebialabs.xlplatform.rest.script.jython.RunScript
import com.xebialabs.xlplatform.rest.script.endpoints.json.ScriptRequest
import scala.util.Success

trait ScriptExtensionRoute extends HttpService with SprayJsonSupport with ScriptResponseProtocol {

  import scala.concurrent.ExecutionContext.Implicits.global

  implicit val timeout = Timeout(15 seconds)

  def settings: Settings

  implicit val JsValueUnmarshaller = rootFormat(JsValueFormat)

  private def jythonActor():ActorRef = actorRefFactory.actorOf(JythonScriptExecutorActor.props())

  private def createEndpointRoute(ep: ScriptEndpoint, auth: AuthenticatedData, body: JsValue = JsNull): Route = {
    pathPrefix("extension") {
      path(ep.getPathMatcher) {
        parameterMultiMap { params =>
          onComplete(jythonActor ? RunScript(ep.script, ScriptRequest(params, body), auth)) {
            case Success(d @ ScriptDone(_, _, _, statusCode, headers, None)) =>
              respondWithStatus(statusCode.map(StatusCode.int2StatusCode(_)).getOrElse(StatusCodes.OK)) {
                respondWithHeaders(headers.map(p => RawHeader(p._1, p._2)).toList) {
                  complete(ScriptResponse(d))
                }
              }
            case Success(d @ ScriptDone(_, _, _, _, _, Some(e))) => complete(StatusCodes.InternalServerError, ScriptResponse(d))
            case Failure(e) if e.isInstanceOf[AskTimeoutException] => complete(StatusCodes.RequestTimeout, e)
            // TODO missing catchall case
          }
        }
      }
    }
  }

  def customScriptEndpoint(endpoint: ScriptEndpoint)(auth: AuthenticatedData): Route = {
    endpoint.method match {
      case "GET" => get {
        createEndpointRoute(endpoint, auth)
      }
      case "POST" => post {
        entity(as[Option[JsValue]]) {
          body =>
            createEndpointRoute(endpoint, auth, body.getOrElse(JsNull))
          }
      }
      case "PUT" => put {
        entity(as[Option[JsValue]]) {
          body =>
            createEndpointRoute(endpoint, auth, body.getOrElse(JsNull))
        }
      }
      case "DELETE" => delete {
        createEndpointRoute(endpoint, auth)
      }
    }
  }

  def customScriptEndpoints(endpoints: Seq[ScriptEndpoint]): Seq[AuthenticatedRoute] = endpoints.map(customScriptEndpoint)

  def customScriptEndpoints: Seq[AuthenticatedRoute] = customScriptEndpoints(ScriptEndpoints(settings.XlDeploy.ServerExtension.file))

}
