package com.xebialabs.xlplatform.rest.script.endpoints.dynamic

import com.xebialabs.xlplatform.rest.script.endpoints._
import spray.routing.{HttpServiceActor, RequestContext}

abstract class ExtensionRouteActor(routeNames: Seq[String]) extends HttpServiceActor {
  override def receive: Receive = {
    case (auth: AuthenticatedData, ctx: RequestContext) =>
      val sealedRoute = sealRoute(joinRoutes(auth))
      sealedRoute(ctx)
  }

  def joinRoutes(auth: AuthenticatedData) = {
    routeNames.map(n => getClass.getMethod(n).invoke(this).asInstanceOf[AuthenticatedRoute]).map(_(auth)).reduce(_ ~ _)
  }
}
