package com.xebialabs.xlplatform.rest.script.endpoints.json

import spray.json._
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind, Descriptor}
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import scala.collection.immutable.ListMap
import PropertyKind._
import java.util.{Collection => JCollection, Map => JMap}

trait CiJsonProtocol extends DefaultJsonProtocol {

  import collection.convert.wrapAll._

  def getOption(ci: ConfigurationItem, pd: PropertyDescriptor) = Option(pd.get(ci))

  class ConfigurationItemFormat(depth: Int = 1) extends RootJsonFormat[ConfigurationItem] {
    override def read(json: JsValue): BaseConfigurationItem = ???

    override def write(ci: ConfigurationItem): JsValue = {
      writeCi(ci, depth)
    }

    def writeCi(ci: ConfigurationItem, depth: Int, seen: Set[String] = Set()): JsValue = {
      val descriptor: Descriptor = ci.getType.getDescriptor

      def writeBasics: Map[String, Option[JsValue]] = ListMap(
        "id" -> Option(ci.getId).map(JsString(_)),
        "type" -> Option(ci.getType).map(t => JsString(t.toString)))

      def writeAll: Map[String, Option[JsValue]] = {
        def getTokenOption: Option[JsValue] = ci match {
          case bci: BaseConfigurationItem => Option(bci.get$token()).map(JsString(_))
          case _ => None
        }

        def asList[A](c: Any): List[A] = c match {
          case jc: JCollection[_] => jc.asInstanceOf[JCollection[A]].toList
          case s: Iterable[_] => s.asInstanceOf[Iterable[A]].toList
          case _ => throw new IllegalArgumentException(s"Do not know how to convert [$c] to a List[_]")
        }

        def asMap[A, B](c: Any): List[(A, B)] = c match {
          case jm: JMap[_, _] => jm.toMap.asInstanceOf[Map[A, B]].toList
          case s: Map[_, _] => s.asInstanceOf[Map[A, B]].toList
          case _ => throw new IllegalArgumentException(s"Do not know how to convert [$c] to a Map[_, _]")
        }

        def writeSub(sub: ConfigurationItem, depth: Int) = writeCi(sub, depth, seen + ci.getId)

        val jsonProperties: Iterable[(String, Option[JsValue])] = descriptor.getPropertyDescriptors.map { pd =>
          (pd.getName, pd.getKind match {
            case BOOLEAN => getOption(ci, pd).map(b => JsBoolean(b.asInstanceOf[Boolean]))
            case INTEGER => getOption(ci, pd).map(i => JsNumber(i.asInstanceOf[Integer]))
            case STRING => getOption(ci, pd).map(s => JsString(s.toString))
            case ENUM => getOption(ci, pd).map(e => JsString(e.toString))
            case CI => getOption(ci, pd).map(ci => writeSub(ci.asInstanceOf[ConfigurationItem], 0))
            case LIST_OF_STRING | SET_OF_STRING => getOption(ci, pd).map(los => JsArray(asList[String](los).map(JsString(_))))
            case LIST_OF_CI | SET_OF_CI if pd.isAsContainment => getOption(ci, pd).map(loc => JsArray(asList[ConfigurationItem](loc).map(writeSub(_, depth - 1))))
            case LIST_OF_CI | SET_OF_CI => getOption(ci, pd).map(loc => JsArray(asList[ConfigurationItem](loc).map(writeSub(_, 0))))
            case MAP_STRING_STRING => getOption(ci, pd).map(mss => JsObject(asMap[String, String](mss).map{ case(s1, s2) => (s1, JsString(s2))}))
          })
        }

        writeBasics.+(("$token", getTokenOption)).++(jsonProperties).filter(_._2.isDefined)
      }

      depth match {
        case 0 => writeBasics.toJson
        case _ if seen.contains(ci.getId) => writeBasics.toJson
        case _ => writeAll.toJson
      }
    }
  }
}
