package com.xebialabs.xlplatform.rest.script.endpoints.json

import spray.json._
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.python.core.{PyNone, PyException}

trait ScriptResponseProtocol extends DefaultJsonProtocol with CiJsonProtocol {

  implicit var ciSerializer: ConfigurationItemFormat = new ConfigurationItemFormat(10)

  implicit object ThrowableFormat extends RootJsonFormat[Option[Throwable]] {
    def write(obj: Option[Throwable]): JsValue = obj match {
      case None =>
        JsNull
      case Some(e: PyException) if e.isInstanceOf[PyException] && e.value != null && !e.value.isInstanceOf[PyNone] =>
        JsString(e.value.toString)
      case Some(e) if e.isInstanceOf[PyException] =>
        JsString(s"Exception of type ${e.getClass.getSimpleName} happened")
      case Some(e: Throwable) =>
        JsString(e.getMessage)
    }
    def read(json: JsValue): Option[Throwable] = None
  }

  implicit object AnyJsonFormat extends JsonFormat[Any] {
    import collection.convert.wrapAll._
    def write(x: Any) = x match {
      case n: Int => JsNumber(n)
      case n: Double => JsNumber(n)
      case n: java.lang.Double => JsNumber(n)
      case s: String => JsString(s)
      case x: Seq[_] => seqFormat[Any].write(x)
      case x: java.util.List[_] => seqFormat[Any].write(x)
      case x: java.util.Map[Any, Any] => mapFormat[Any, Any].write(x.toMap)
      case m: Map[Any, Any] => m.map({
        case (key, value) => (Option(key).map(_.toString).getOrElse("null").toJson, value.toJson)
      }).toJson
      case b: Boolean if b => JsTrue
      case b: Boolean if !b => JsFalse
      case null => JsNull
      case ci: ConfigurationItem => ci.toJson
      case _ => serializationError(s"Do not understand object of type ${x.getClass.getName}")
    }

    def read(value: JsValue) = ???
  }

  implicit val scriptResponseFormat = jsonFormat4(ScriptResponse.apply)

}
