/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cluster;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.cluster.ClusterConfig;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlplatform.cluster.NodeState$;
import com.xebialabs.xlplatform.cluster.XlCluster$;
import com.xebialabs.xlplatform.cluster.XlClusterProvider;
import com.xebialabs.xlplatform.config.ProductConfiguration;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u000593Aa\u0002\u0005\u0001#!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003/\u0001\u0011\u0005\u0011I\u0001\rEKBdw._\"mkN$XM]!di>\u00148+_:uK6T!!\u0003\u0006\u0002\u000f\rdWo\u001d;fe*\u00111\u0002D\u0001\tI\u0016\u0004Hn\\=ji*\u0011QBD\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aD\u0001\u0004G>l7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)1\u000f\u001c45U*\tQ$\u0001\u0005he&T(\u0010\\3e\u0013\ty\"DA\u0004M_\u001e<\u0017N\\4\u0002/adG\r\u0015:pIV\u001cGoQ8oM&<WO]1uS>t\u0007C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0019\u0019wN\u001c4jO*\u0011a\u0005D\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017B\u0001\u0015$\u0005Q\u0001&o\u001c3vGR\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"\"aK\u0017\u0011\u00051\u0002Q\"\u0001\u0005\t\u000b\u0001\u0012\u0001\u0019A\u0011\u0002\t\t|w\u000e\u001e\u000b\u0002aA\u00111#M\u0005\u0003eQ\u0011A!\u00168ji\u0006y\"/Z:pYZ,\u0017i[6b\u0011>\u001cHO\\1nK^KG\u000f\u001b$bY2\u0014\u0017mY6\u0015\u0005Ub\u0004C\u0001\u001c;\u001b\u00059$B\u0001\u00139\u0015\tId\"\u0001\u0005usB,7/\u00194f\u0013\tYtG\u0001\u0004D_:4\u0017n\u001a\u0005\u0006I\u0011\u0001\r!N\u0001\u001ce\u0016\u001cx\u000e\u001c<f\u0003.\\\u0017\rU8si^KG\u000f\u001b$bY2\u0014\u0017mY6\u0015\u0005Uz\u0004\"\u0002!\u0006\u0001\u0004)\u0014AE2p]\u001aLwmV5uQ\"{7\u000f\u001e8b[\u0016$\"\u0001\r\"\t\u000b\u00112\u0001\u0019A\u001b)\u0005\u0001!\u0005CA#M\u001b\u00051%BA$I\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003\u0013*\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0017\u0006\u0019qN]4\n\u000553%!C\"p[B|g.\u001a8u\u0001")
public class DeployClusterActorSystem
implements Logging {
    private final ProductConfiguration xldProductConfiguration;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeployClusterActorSystem deployClusterActorSystem = this;
        synchronized (deployClusterActorSystem) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public void boot() {
        Config fallbackSettings = ConfigFactory.parseString((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | name = \"xld-hotstandby-cluster\"\n        | membership {\n        |   heartbeat = 10 seconds\n        |   ttl = 60 seconds\n        |   jdbc {\n        |     pool-name = \"ClusterPool\"\n        |     max-pool-size = 1\n        |     minimum-idle = 1\n        |     connection-timeout = 30 seconds\n        |     max-life-time = 30 minutes\n        |     idle-timeout = 10 minutes\n        |     leak-connection-threshold = 15 seconds\n        |   }\n        | }\n        | akka {\n        |   actor.provider = \"akka.cluster.ClusterActorRefProvider\"\n        |   loggers = [\"akka.event.slf4j.Slf4jLogger\"]\n        |   loglevel = \"INFO\"\n        | }\n      ")));
        Config systemClusterConfig = (Config)Try$.MODULE$.apply((Function0 & Serializable)() -> $this.xldProductConfiguration.configuration().getConfig("deploy.cluster")).getOrElse((Function0 & Serializable)() -> {
            this.logger().info((Function0 & Serializable)() -> "No cluster settings found in deploy-cluster.yaml - assuming Standalone");
            return ConfigFactory.empty();
        });
        this.boot(systemClusterConfig.withFallback((ConfigMergeable)fallbackSettings));
    }

    public Config resolveAkkaHostnameWithFallback(Config config) {
        Config confWithHostname = this.xldProductConfiguration.configuration().hasPath("server.hostname") ? config.withValue("akka.remote.artery.canonical.hostname", this.xldProductConfiguration.configuration().getValue("server.hostname")) : (this.xldProductConfiguration.configuration().hasPath("deploy.server.hostname") ? config.withValue("akka.remote.artery.canonical.hostname", this.xldProductConfiguration.configuration().getValue("deploy.server.hostname")) : config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)new StringBuilder(39).append("akka.remote.artery.canonical.hostname= ").append(ServerConfiguration.getInstance().getServerHostname()).toString())));
        return confWithHostname;
    }

    public Config resolveAkkaPortWithFallback(Config configWithHostname) {
        Config confWithPort = this.xldProductConfiguration.configuration().hasPath("deploy.cluster.node.port") ? configWithHostname.withValue("akka.remote.artery.canonical.port", this.xldProductConfiguration.configuration().getValue("deploy.cluster.node.port")) : configWithHostname.withFallback((ConfigMergeable)ConfigFactory.parseString((String)new StringBuilder(34).append("akka.remote.artery.canonical.port=").append(Integer.toString(ServerConfiguration.getInstance().getClusterNodePort())).toString()));
        return confWithPort;
    }

    public void boot(Config config) {
        ClusterConfig clusterConfig = new ClusterConfig(this.resolveAkkaPortWithFallback(this.resolveAkkaHostnameWithFallback(config)));
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(8).append("mode is ").append(clusterConfig.mode()).toString());
        ClusterMode clusterMode = clusterConfig.mode();
        if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
            NodeState$.MODULE$.setActive(true);
            return;
        }
        if (ClusterMode.HotStandby$.MODULE$.equals(clusterMode) ? true : ClusterMode.Full$.MODULE$.equals(clusterMode)) {
            ActorSystem mgmtActorSystem = ActorSystem$.MODULE$.apply(clusterConfig.name(), clusterConfig.config());
            XlCluster$.MODULE$.init(clusterConfig);
            ((XlClusterProvider)XlCluster$.MODULE$.apply(mgmtActorSystem)).start((Function0)(JFunction0.mcV.sp & Serializable)() -> {});
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Cluster mode ").append(clusterMode).append(" is not supported.").toString());
    }

    public DeployClusterActorSystem(ProductConfiguration xldProductConfiguration) {
        this.xldProductConfiguration = xldProductConfiguration;
        Logging.$init$((Logging)this);
    }
}

