/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public class CustomForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private static final AccessControlContext ACC = CustomForkJoinWorkerThreadFactory.contextWithPermissions(new AllPermission());

    static AccessControlContext contextWithPermissions(Permission ... perms) {
        Permissions permissions = new Permissions();
        for (Permission perm : perms) {
            permissions.add(perm);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    @Override
    public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return AccessController.doPrivileged(() -> new CustomForkJoinWorkerThread(pool, ClassLoader.getSystemClassLoader()), ACC);
    }

    static class CustomForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        protected CustomForkJoinWorkerThread(ForkJoinPool pool, ClassLoader ccl) {
            super(pool);
            super.setContextClassLoader(ccl);
        }
    }
}

