package com.xebialabs.deployit.config

import com.fasterxml.jackson.databind.ObjectMapper
import org.springframework.context.annotation.Configuration
import org.springframework.http.converter.HttpMessageConverter
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter
import org.springframework.scheduling.annotation.EnableScheduling
import org.springframework.web.method.support
import org.springframework.web.servlet.config.annotation.{DefaultServletHandlerConfigurer, EnableWebMvc, ResourceHandlerRegistry, WebMvcConfigurer}
import org.springframework.web.servlet.mvc.method.annotation.PrincipalMethodArgumentResolver

import java.util

@Configuration
@EnableWebMvc
@EnableScheduling
class WebConfiguration(objectMapper: ObjectMapper) extends WebMvcConfigurer {

  override def configureDefaultServletHandling(configurer: DefaultServletHandlerConfigurer): Unit = configurer.enable()

  override def addResourceHandlers(registry: ResourceHandlerRegistry): Unit = registry.addResourceHandler("/web/**")

  override def addArgumentResolvers(resolvers: util.List[support.HandlerMethodArgumentResolver]): Unit =
    resolvers.add(new PrincipalMethodArgumentResolver)

  override def extendMessageConverters(converters: util.List[HttpMessageConverter[_]]): Unit =  {
    super.extendMessageConverters(converters)
    converters.stream().filter(_.isInstanceOf[MappingJackson2HttpMessageConverter])
      .map(_.asInstanceOf[MappingJackson2HttpMessageConverter])
      .forEach(_.setObjectMapper(objectMapper))
  }
}
