/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.jetty;

import ai.digital.configuration.central.deploy.ClientProperties;
import ai.digital.configuration.central.deploy.ServerSideProperties;
import ai.digital.configuration.central.deploy.server.GzipProperties;
import com.google.common.base.Charsets;
import com.tqdev.metrics.core.MetricRegistry;
import com.xebialabs.deployit.AcceptHeaderConditionalFilter;
import com.xebialabs.deployit.CSPFilter;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.HttpErrorHandler;
import com.xebialabs.deployit.MultipartFilter;
import com.xebialabs.deployit.NoCacheFilter;
import com.xebialabs.deployit.RootPageForwardFilter;
import com.xebialabs.deployit.RootPageMissingErrorHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XLWebApplicationContext;
import com.xebialabs.deployit.config.SameSiteHelper;
import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import com.xebialabs.deployit.jetty.MaintenanceModeFilter;
import com.xebialabs.deployit.jetty.NoOptionsFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.server.jetty.DeploySpringContextLoaderListener;
import com.xebialabs.deployit.server.jetty.XLDWebResource;
import com.xebialabs.deployit.server.jetty.metrics.CustomInstrumentedHandler;
import com.xebialabs.deployit.server.jetty.metrics.CustomMeasureRequestPathFilter;
import com.xebialabs.xlplatform.endpoints.servlet.FlexPekkoStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServletInitializer;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.SessionTrackingMode;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.Assert;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.RelativeRedirectFilter;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.servlet.DispatcherServlet;

public class DeployJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String CONTEXT_PATH = "deployit";
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private ClientProperties clientProperties;
    @Autowired
    private ServerSideProperties serverSideProperties;

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    protected void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupRest(contextRoot);
        this.setupAfterAuthFilters(contextRoot);
        this.setSessionHandler(contextRoot);
        this.setupSessionTimeout(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupMultipartFilter(contextRoot);
        CustomErrorHandler errorHandler = new CustomErrorHandler(new HttpErrorHandler[]{new RootPageMissingErrorHandler(this.serverConfiguration.getWebWelcomePage()), new LicenseMissingErrorHandler()});
        errorHandler.setShowStacks(false);
        errorHandler.setShowMessageInTitle(false);
        contextRoot.setErrorHandler((Request.Handler)errorHandler);
    }

    private void setSessionHandler(WebAppContext contextRoot) {
        if (!this.serverSideProperties.getSession().getActiveUserSessionsEnabled()) {
            SessionHandler sessionHandler = new SessionHandler();
            sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
            sessionHandler.setSessionCookie("SESSION_XLD");
            sessionHandler.setHttpOnly(true);
            if (!this.serverConfiguration.isSsl()) {
                sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration.isSecureCookieEnabled());
            }
            sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)SameSiteHelper.getSameSiteValue((String)SameSiteHelper.getStringValue((String)this.clientProperties.sameSiteCookie(), (String)ClientProperties.DEFAULT_SAMESITE_COOKIE())).name()));
            contextRoot.setSessionHandler(sessionHandler);
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.serverSideProperties.getHttp().getCsp().getEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.serverSideProperties.getHttp().getCsp().getPolicyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupSessionTimeout(WebAppContext contextRoot) {
        if (!this.serverSideProperties.getSession().getActiveUserSessionsEnabled()) {
            int sessionTimeoutSeconds = (int)TimeUnit.MINUTES.toSeconds(this.clientProperties.getSession().getTimeoutMinute());
            contextRoot.getSessionHandler().setMaxInactiveInterval(sessionTimeoutSeconds);
        }
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.add(this.getMimeTypeConfiguration());
        configurations.addAll(this.getConfigurations());
        return configurations.toArray(new Configuration[0]);
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) {
                MimeTypes.Mutable mimeTypes = context.getMimeTypes();
                for (MimeMappings.Mapping mapping : DeployJettyServletWebServerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    private void setupAfterAuthFilters(WebAppContext contextRoot) {
        FilterHolder maintenanceFilterHolder = contextRoot.addFilter(MaintenanceModeFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        maintenanceFilterHolder.setInitParameter("maintenance.forbidden_paths", String.join((CharSequence)",", this.clientProperties.maintenance().forbiddenPaths()));
        maintenanceFilterHolder.setInitParameter("maintenance.context_root", this.serverConfiguration.getWebContextRoot());
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer());
        contextRoot.insertHandler((Handler.Singleton)new CustomInstrumentedHandler(MetricRegistry.getInstance()));
        contextRoot.addFilter(CustomMeasureRequestPathFilter.class, "*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("contentTypes", "application/json|text/html|text/xml|application/xml");
        contextRoot.addFilter(NoOptionsFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        if (this.serverConfiguration.getWebWelcomePage() != null) {
            contextRoot.addFilter(RootPageForwardFilter.class, "/", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("ForwardTarget", this.serverConfiguration.getWebWelcomePage());
        }
        contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/repository/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setClassLoader(Thread.currentThread().getContextClassLoader());
        ServletHolder extensionApiServletHolder = new ServletHolder(FlexPekkoStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, "/api/*");
        contextRoot.addFilter(new FilterHolder((Filter)new AcceptHeaderConditionalFilter((Filter)new ShallowEtagHeaderFilter(), "application/json")), "/deployit/metadata/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(NoCacheFilter.class, "/", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(CharacterEncodingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameters((Map)new HashMap<String, String>(){
            {
                this.put("encoding", Charsets.UTF_8.name());
                this.put("forceEncoding", "true");
            }
        });
        contextRoot.addFilter(RelativeRedirectFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.addDeployDefaultServlet(contextRoot);
        if (this.serverSideProperties.getHttp().getGzip().getEnabled()) {
            this.enableGzipHandler(contextRoot);
        }
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        GzipProperties gzipSettings = this.serverSideProperties.getHttp().getGzip();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, gzipSettings.getCompression(), true));
        gzipHandler.setMinGzipSize(gzipSettings.minSize() * 1024);
        gzipHandler.setExcludedPaths(gzipSettings.getExcludedPaths().toArray(new String[0]));
        contextRoot.insertHandler((Handler.Singleton)gzipHandler);
    }

    private void setupRest(WebAppContext contextRoot) {
        contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        contextRoot.addEventListener((EventListener)((Object)new DeploySpringContextLoaderListener()));
        ServletHolder servletHolder = new ServletHolder(DispatcherServlet.class);
        servletHolder.setDisplayName("defaultservlet");
        servletHolder.getInitParameters().put(SPRING_CTX_CFG_LOCATION_KEY, "classpath:spring/deployit-spring-web.xml");
        servletHolder.setInitOrder(1);
        ServletHolder servletCsrfHolder = new ServletHolder(DispatcherServlet.class);
        servletCsrfHolder.setDisplayName("csrfservlet");
        servletCsrfHolder.getInitParameters().put(SPRING_CTX_CFG_LOCATION_KEY, "classpath:spring/csrf-deployit-spring-web.xml");
        servletCsrfHolder.setInitOrder(1);
        contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/deployit");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        contextRoot.getInitParams().put("contextClass", XLWebApplicationContext.class.getName());
        contextRoot.addServlet(servletHolder, "/deployit/*");
        contextRoot.addServlet(servletCsrfHolder, "/xldeploy/*");
    }

    private void addDeployDefaultServlet(WebAppContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setServlet((Servlet)new DefaultServlet());
        holder.setInitParameter("dirAllowed", "false");
        URI path = null;
        Resource baseResource = null;
        try {
            ResourceFactory resourceFactory = context.getResourceFactory();
            path = Path.of(".", new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toUri();
            baseResource = resourceFactory.newResource(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred while setting base resource", e);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(baseResource);
        resources.add(new XLDWebResource());
        Resource resource = ResourceFactory.combine(resources);
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        context.getServletHandler().getServletMapping("/").setFromDefaultDescriptor(true);
        context.getServletHandler().setDecodeAmbiguousURIs(true);
        context.setBaseResource(resource);
    }

    private void setupMultipartFilter(WebAppContext context) {
        FilterHolder multipartFilter = new FilterHolder(MultipartFilter.class);
        multipartFilter.setName("multipartFilter");
        context.addFilter(multipartFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
    }
}

