package com.xebialabs.deployit;

import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

/**
 */
public class UnhandledExceptionMapper implements ExceptionMapper<RuntimeException> {

	@Override
	public Response toResponse(final RuntimeException exception) {
		logger.debug("Intercepting (possibly) unhandled exception...");
		// Safeguard that we do not by accident handle DeployitExceptions
		if (exception instanceof DeployitException) {
			return new DeployitExceptionMapper().toResponse((DeployitException) exception);
		} else {
			logger.error("Unhandled Exception: {}", exception);
			final Response.ResponseBuilder builder = ResponseFactory.serverError().type(MediaType.APPLICATION_XML);
			builder.header("Unhandled-Exception", "true");
			builder.header("Exception-Type", exception.getClass().getName());
			builder.entity(exception.getMessage());
			return builder.build();
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);
}
