/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitExceptionMapper
implements ExceptionMapper<DeployitException> {
    private static final Logger logger = LoggerFactory.getLogger(DeployitExceptionMapper.class);

    public Response toResponse(DeployitException exception) {
        logger.info("Intercepting DeployitException", (Throwable)exception);
        HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
        int status = 500;
        if (annotation != null) {
            status = annotation.statusCode();
        }
        Response.ResponseBuilder builder = ResponseFactory.status((int)status).type("application/xml");
        builder.header("Deployit-Exception", (Object)"true");
        builder.header("Exception-Type", (Object)exception.getClass().getName());
        Response response = builder.entity((Object)exception.getMessage()).build();
        logger.info("Returning response {}", (Object)response);
        return response;
    }
}

