/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.jetty;

import com.google.common.base.Strings;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URL;

@SuppressWarnings("serial")
public class ClassPathResourceContentServlet extends DefaultServlet {
	private static final String FALLBACK_SYSTEM_PROPERTY_NAME = "com.xebialabs.deployit.jetty.ClassPathResourceContentServlet.fallbackDirectory";

	private final String packageName;
	private final boolean fallbackToDevelopmentResources;
	private final String fallbackDirectory;

	public ClassPathResourceContentServlet(String packageName) {
		assert packageName != null;
		this.packageName = packageName.replace('.', '/');
		fallbackDirectory = System.getProperty(FALLBACK_SYSTEM_PROPERTY_NAME);
		fallbackToDevelopmentResources = !Strings.isNullOrEmpty(fallbackDirectory);
		if (logger.isDebugEnabled()) {
			logger.debug("Using " + this.packageName + " as the document root on the classpath (fallbackToDevelopmentResources="
					+ fallbackToDevelopmentResources + ").");
		}

	}

	@Override
	public Resource getResource(String pathInContext) {
		pathInContext = pathInContext.replace("-@project.version@", "");
		final String resourcePath = "/" + packageName + pathInContext;
		if (logger.isDebugEnabled())
			logger.debug("Requested resource " + resourcePath + " to load");
		URL url = getClass().getResource(resourcePath);
		try {
			Resource r = Resource.newResource(url);
			if (r == null || !r.exists()) {
				if (fallbackToDevelopmentResources) {
					String fallbackUrl = "file:" + fallbackDirectory + pathInContext;
					if (logger.isInfoEnabled()) {
						logger.info("Cannot find " + resourcePath + " in classpath, falling back to URL " + fallbackUrl);
					}
					r = Resource.newResource(fallbackUrl);
				}
			}
			if (r == null || !r.exists()) {
				if (resourcePath.endsWith(".gz")) {
					//Browsers, always request the gz version first and then fallback to the uncompressed variant
					logger.debug("Cannot find " + resourcePath + " in classpath");
				} else {
					logger.error("Cannot find " + resourcePath + " in classpath");
				}
			}
			return r;
		} catch (IOException exc) {
			throw new RuntimeException(exc);
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(ClassPathResourceContentServlet.class);
}
