package com.xebialabs.deployit.jetty;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodOverrideServletRequest extends HttpServletRequestWrapper {

	public static final String DEFAULT_HEADER = "X-HTTP-Method-Override";

	private final String methodOverrideHeader;

	private transient String method;

	/**
	 * @param request
	 *            the original request
	 * @param methodOverrideHeader
	 *            the name of the header that can be used to specify an overriding method
	 */
	public HttpMethodOverrideServletRequest(HttpServletRequest request, String methodOverrideHeader) {
		super(request);
		this.methodOverrideHeader = methodOverrideHeader;
	}

	@Override
	public String getMethod() {
		if (method == null) {
			method = resolveMethod();
		}
		return method;
	}

	protected String resolveMethod() {
		String headerValue = getHeader(methodOverrideHeader);
		String method;

		if (headerValue != null) {
			method = headerValue;
			logger.debug("Overriding " + super.getMethod() + " request to be a " + method + " request because a " + methodOverrideHeader
			        + " header was present");
		} else {
			method = super.getMethod();
			logger.debug("Not overriding a " + method + " request");
		}
		return method;
	}

	private static Logger logger = LoggerFactory.getLogger(HttpMethodOverrideServletRequest.class);

}
