/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit;

import com.xebialabs.deployit.setup.Setup;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class DeployitBootstrapper {

	public static void main(String[] args) {
		final DeployitOptions deployitOptions = parseCommandLine(args);

		if (deployitOptions == null) {
			return;
		}

		SecurityContextHolder.setStrategyName(SecurityContextHolder.MODE_INHERITABLETHREADLOCAL);

		ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
		logger.info("Deployit version " + releaseInfo.getVersion() + " (built at " + releaseInfo.getDate() + ")");
		logger.info("(c) 2008-2011 XebiaLabs");

		DeployitConfig configuration = new DeployitConfig();
		if (deployitOptions.isDoSetup()) {
			startSetup(deployitOptions);
		} else {
			if (!configuration.exists()) {
				logger.error("Configuration not found...");
				startSetup(deployitOptions);
			}
			startServer(deployitOptions);
		}
	}

	private static DeployitOptions parseCommandLine(String[] args) {
		DeployitOptions options = new DeployitOptions();
		final CmdLineParser parser = new CmdLineParser(options);
		try {
			parser.parseArgument(args);
		} catch (CmdLineException e) {
			System.err.println(e.getMessage());
			System.err.println("java -cp deployit-server-<version>.jar [options...] com.xebialabs.deployit.Deployit arguments...");
			parser.printUsage(System.err);
			return null;
		}
		return options;

	}

	private static void startServer(DeployitOptions deployitOptions) {
		logger.info("Starting server...");
		Server.start(deployitOptions);
	}

	private static void startSetup(DeployitOptions deployitOptions) {
		logger.info("Starting setup...");
		Setup.setup(deployitOptions);
	}

	private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);
}
