/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.google.common.base.Strings;
import com.xebialabs.deployit.jetty.HttpHeaderOverrideServletRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderOverrideFilter
implements Filter {
    public static final String QUERY_PARAM = "acceptHeader";
    private String queryParam;
    private static Logger logger = LoggerFactory.getLogger(RequestHeaderOverrideFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.queryParam = filterConfig.getInitParameter(QUERY_PARAM);
        if (Strings.isNullOrEmpty((String)this.queryParam)) {
            this.queryParam = QUERY_PARAM;
        }
        logger.info("Initialized to check for QueryString Variable {}", (Object)QUERY_PARAM);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRequest filteredRequest = request;
        if (request instanceof HttpServletRequest) {
            filteredRequest = this.processRequest(request);
        }
        chain.doFilter(filteredRequest, response);
    }

    private ServletRequest processRequest(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return new HttpHeaderOverrideServletRequest(httpRequest, QUERY_PARAM);
    }
}

