/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeadersEncodedAsParametersFilter
implements Filter {
    public static final String X_HEADER_PREFIX = "X-Header-";
    private static Logger logger = LoggerFactory.getLogger(RequestHeadersEncodedAsParametersFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("Initialized to check for Http Headers in Post Request parameters.");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ServletRequest servletRequest2 = servletRequest;
        if (servletRequest instanceof HttpServletRequest) {
            servletRequest2 = this.processRequest((HttpServletRequest)servletRequest);
        }
        filterChain.doFilter(servletRequest2, servletResponse);
    }

    private ServletRequest processRequest(HttpServletRequest httpServletRequest) {
        return new HttpHeadersEncodedAsParametersServletRequest(httpServletRequest);
    }

    private static class HttpHeadersEncodedAsParametersServletRequest
    extends HttpServletRequestWrapper {
        HttpHeadersEncodedAsParametersServletRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public String getHeader(String string) {
            String string2 = this.getHeaderFromParameters(string);
            if (string2 != null) {
                logger.debug("Header {} resolved from request parameters", (Object)string);
            } else {
                string2 = super.getHeader(string);
            }
            return string2;
        }

        private String getHeaderFromParameters(String string) {
            String string2 = RequestHeadersEncodedAsParametersFilter.X_HEADER_PREFIX + string;
            return this.getParameter(string2);
        }

        public String getContentType() {
            String string = this.getHeaderFromParameters("Content-Type");
            if (string == null) {
                string = super.getContentType();
            }
            return string;
        }

        public Enumeration getHeaders(String string) {
            ArrayList arrayList = Collections.list(super.getHeaders(string));
            String string2 = this.getHeaderFromParameters(string);
            if (string2 != null) {
                logger.debug("Header {} resolved from request parameters", (Object)string);
                arrayList.add(string2);
            }
            return Collections.enumeration(arrayList);
        }

        public Enumeration getHeaderNames() {
            ArrayList arrayList = Collections.list(super.getHeaderNames());
            Enumeration enumeration = this.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(RequestHeadersEncodedAsParametersFilter.X_HEADER_PREFIX) || arrayList.contains(string = string2.substring(RequestHeadersEncodedAsParametersFilter.X_HEADER_PREFIX.length()))) continue;
                logger.debug("Header {} resolved from request parameters", (Object)string);
                arrayList.add(string);
            }
            return Collections.enumeration(arrayList);
        }
    }
}

