/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.DeployitConfig;
import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.core.rest.resteasy.Mime4jStorageProvider;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.MethodOverrideFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.plugin.api.boot.PluginBooter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.jcr.Repository;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.j2ee.JcrRemotingServlet;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderListener;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.DelegatingFilterProxy;

public class Server {
    private final DeployitConfig deployItConfiguration;
    private org.mortbay.jetty.Server jettyServer;
    private Context contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger;

    public static void start(DeployitOptions deployitOptions) {
        DeployitConfiguration.load();
        Server server = new Server(DeployitConfiguration.getInstance(), deployitOptions);
        server.start();
    }

    public Server(DeployitConfig deployitConfig, DeployitOptions deployitOptions) {
        this.deployItConfiguration = deployitConfig;
        if (this.portIsAvailable()) {
            this.setupJetty(deployitOptions);
            this.bootPlugins();
            this.setupSpring();
            this.setupRest();
        } else {
            logger.error("Cannot start Deployit server, port " + this.deployItConfiguration.getHttpPort() + " already in use.");
            logger.error("Perhaps another instance of Deployit is running. If so, please shutdown the other instance of Deployit.");
            System.exit(1);
        }
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.deployItConfiguration.getHttpPort());
            serverSocket.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void setupJetty(DeployitOptions deployitOptions) {
        String string;
        SslSocketConnector sslSocketConnector;
        int n = this.deployItConfiguration.getHttpPort();
        String string2 = this.deployItConfiguration.getWebContextRoot();
        String string3 = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{n, string2, string3});
        }
        this.jettyServer = new org.mortbay.jetty.Server();
        SocketConnector socketConnector = new SocketConnector();
        if (this.deployItConfiguration.isSsl()) {
            logger.debug("Setting up Jetty to use SSL");
            sslSocketConnector = new SslSocketConnector();
            socketConnector.setMaxIdleTime(30000);
            sslSocketConnector.setKeystore(this.deployItConfiguration.getKeyStorePath());
            sslSocketConnector.setPassword(this.deployItConfiguration.getKeyStorePassword());
            sslSocketConnector.setKeyPassword(this.deployItConfiguration.getKeyStoreKeyPassword());
            string = this.deployItConfiguration.getSslProtocol();
            if (!Strings.nullToEmpty((String)string).trim().isEmpty()) {
                sslSocketConnector.setProtocol(string);
            }
            socketConnector = sslSocketConnector;
        }
        socketConnector.setHost(this.deployItConfiguration.getHttpBindAddress());
        socketConnector.setPort(n);
        logger.info("Connector listen {} on {}:{}", new Object[]{this.deployItConfiguration.isSsl() ? "secure" : "no-secure", socketConnector.getHost(), socketConnector.getPort()});
        this.jettyServer.addConnector((Connector)socketConnector);
        sslSocketConnector = new BoundedThreadPool();
        sslSocketConnector.setMinThreads(this.deployItConfiguration.getMinThreads());
        sslSocketConnector.setMaxThreads(this.deployItConfiguration.getMaxThreads());
        this.jettyServer.setThreadPool((ThreadPool)sslSocketConnector);
        this.jettyServer.setGracefulShutdown(1000);
        this.contextRoot = new Context((HandlerContainer)this.jettyServer, string2, 1);
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", 1);
        this.contextRoot.addFilter(MethodOverrideFilter.class, "*", 1);
        string = new ServletHolder();
        string.setServlet((Servlet)new ClassPathResourceContentServlet(string3));
        this.contextRoot.addServlet((ServletHolder)string, "/");
        if (deployitOptions.isTestModeEnabled()) {
            this.setupJackRabbitAccess();
        }
    }

    private void setupJackRabbitAccess() {
        ServletHolder servletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            protected Repository getRepository() {
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)webApplicationContext.getBean("jcrRepository");
            }
        });
        servletHolder.setName("RepositoryAccessServlet");
        String string = "/repository-test";
        servletHolder.setInitParameter("resource-path-prefix", string);
        this.contextRoot.addServlet(servletHolder, string + "/*");
        ServletHolder servletHolder2 = new ServletHolder((Servlet)new JcrRemotingServlet(){

            public Repository getRepository() {
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)webApplicationContext.getBean("jcrRepository");
            }
        });
        servletHolder2.setName("Webdav");
        string = "/repository";
        servletHolder2.setInitParameter("resource-path-prefix", string);
        servletHolder2.setInitParameter("missing-auth-mapping", "guestcredentials");
        this.contextRoot.addServlet(servletHolder2, string + "/*");
    }

    private void bootPlugins() {
        PluginBooter.boot();
    }

    private void setupSpring() {
        Map map = this.contextRoot.getInitParams();
        map.put("contextConfigLocation", "classpath:spring/deployit-context.xml,classpath:deployit-security.xml,classpath*:hotfix-context.xml");
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + (String)map.get("contextConfigLocation"));
        }
        FilterHolder filterHolder = new FilterHolder(DelegatingFilterProxy.class);
        filterHolder.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filterHolder, "/deployit/*", 1);
    }

    private void setupRest() {
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)new SpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/deployit");
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/deployit/*");
        this.contextRoot.setResourceBase(".");
        DefaultStorageProvider.setInstance((StorageProvider)new Mime4jStorageProvider());
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            if (logger.isDebugEnabled()) {
                logger.debug("Jetty started");
            }
            logger.info("The Deployit server has started.");
            this.createShutdownEventThreadAndShutdownHook();
            String string = (this.deployItConfiguration.isSsl() ? "https" : "http") + "://" + InetAddress.getLocalHost().getHostName() + ":" + this.deployItConfiguration.getHttpPort() + this.deployItConfiguration.getWebContextRoot();
            logger.info("You can now point your browser to {} or start the command line interface with \"cli.sh\" or \"cli.cmd\"", (Object)string);
        }
        catch (Exception exception) {
            logger.error("Error occured while starting Jetty", (Throwable)exception);
        }
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down the Deployit server.");
            try {
                this.jettyServer.stop();
                logger.info("The Deployit server has shut down.");
            }
            catch (Exception exception) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)exception);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                logger.trace("Shutting down the Deployit server because a shutdown event was received.");
                Server.this.stop();
            }
        });
        thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.trace("Shutting down the Deployit server because the process is being terminated.");
                Server.this.stop();
            }
        }));
    }

    static {
        EventBus.registerForEvent(ShutdownEvent.class, (EventCallback)new EventCallback<ShutdownEvent>(){

            public void receive(ShutdownEvent shutdownEvent) {
                logger.trace("Received shutdown event.");
                shutdownLatch.countDown();
            }
        });
        logger = LoggerFactory.getLogger(Server.class);
    }
}

