/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sanitizer {
    private static final AtomicReference<Policy> policyReference = new AtomicReference();
    private static final Logger logger = LoggerFactory.getLogger(Sanitizer.class);

    public static String sanitize(String input) {
        if (policyReference.get() == null) {
            Sanitizer.init();
        }
        Policy policy = policyReference.get();
        AntiSamy antiSamy = new AntiSamy(policy);
        try {
            CleanResults scan = antiSamy.scan(input);
            if (!scan.getErrorMessages().isEmpty()) {
                logger.warn("Found errors during sanitation: {}", (Object)scan.getErrorMessages());
            }
            return scan.getCleanHTML();
        }
        catch (ScanException e) {
            throw new RuntimeException(e);
        }
        catch (PolicyException e) {
            throw new RuntimeException(e);
        }
    }

    private static void init() {
        InputStream resourceAsStream = Sanitizer.class.getResourceAsStream("/antisamy-slashdot-1.4.4.xml");
        try {
            Policy instance = Policy.getInstance((InputStream)resourceAsStream);
            policyReference.compareAndSet(null, instance);
        }
        catch (PolicyException e) {
            throw new RuntimeException(e);
        }
    }
}

