package com.xebialabs.deployit;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import org.springframework.stereotype.Component;

// PLEASE NOTE: Do not remove the implemented interface, it is needed by RestEasy, even though the ClosingExceptionMapper also implements it.
@Provider
@Component
public class DeployitExceptionMapper extends ClosingExceptionMapper<DeployitException> implements ExceptionMapper<DeployitException> {

	@Override
	public Response handleException(DeployitException exception) {
		logger.info("Intercepting DeployitException", exception);
		final HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
		int status = 500;
		if (annotation != null) {
			status = annotation.statusCode();
		}
		final Response.ResponseBuilder builder = ResponseFactory.status(status).type(MediaType.APPLICATION_XML);
		builder.header("Deployit-Exception", "true");
		builder.header("Exception-Type", exception.getClass().getName());
		final Response response = builder.entity(Sanitizer.sanitize(Exceptions.getAllMessages(exception))).build();
		logger.info("Returning response {}", response);
		return response;
	}

	private static final Logger logger = LoggerFactory.getLogger(DeployitExceptionMapper.class);

}
