package com.xebialabs.deployit.jetty;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodOverrideFilter implements Filter {

	public static final String HEADER_PARAM = "methodOverrideHeader";

	private String header;

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		header = filterConfig.getInitParameter(HEADER_PARAM);
		if (header == null || header.length() == 0) {
			header = HttpMethodOverrideServletRequest.DEFAULT_HEADER;
		}
		logger.info("Initialized to check for header {}", header);
	}

	@Override
	public void destroy() {
		// Empty
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		ServletRequest filteredRequest = request;
		if (request instanceof HttpServletRequest) {
			filteredRequest = processRequest(request);
		}
		chain.doFilter(filteredRequest, response);
	}

	protected ServletRequest processRequest(ServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		return new HttpMethodOverrideServletRequest(httpRequest, header);
	}

	private static Logger logger = LoggerFactory.getLogger(MethodOverrideFilter.class);

}
