package com.xebialabs.deployit;

import java.util.List;

import com.google.common.base.Joiner;

import static com.google.common.collect.Lists.newArrayList;

public class Exceptions {

    public static String getAllMessages(Exception e) {
        List<String> msgs = newArrayList();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            String message = cause.getLocalizedMessage();
            if (message == null) {
                if (cause.getCause() == null) {
                    msgs.add(cause.toString());
                }
            } else {
                if (cause.getCause() == null || !cause.getCause().toString().equals(message)) {
                    msgs.add(message);
                }
            }
        }
        return Joiner.on("\n").join(msgs);
    }
}
