/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.UrlUtils;

public class AccessLogFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String method = servletRequest.getMethod();
        String url = UrlUtils.buildRequestUrl((HttpServletRequest)servletRequest);
        long startMs = System.currentTimeMillis();
        chain.doFilter(request, response);
        String username = this.getUsername(servletRequest);
        String ip = this.getRequesterIP(servletRequest);
        String ua = this.getRequestUserAgent(servletRequest);
        String status = this.getStatus(response);
        long endMs = System.currentTimeMillis();
        logger.debug(String.format("%6dms %s - %s - %s \"%s %s\" - %s", endMs - startMs, status, ip, username, method, url, ua));
    }

    private String getRequestUserAgent(HttpServletRequest servletRequest) {
        return servletRequest.getHeader("User-Agent");
    }

    private String getUsername(HttpServletRequest servletRequest) {
        try {
            SecurityContext springContextAttribute = SecurityContextHolder.getContext();
            if (springContextAttribute != null && springContextAttribute.getAuthentication() != null) {
                return springContextAttribute.getAuthentication().getName();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return "";
    }

    private String getStatus(ServletResponse response) {
        if (response instanceof HttpServletResponse) {
            return String.valueOf(((HttpServletResponse)response).getStatus());
        }
        return "";
    }

    private String getRequesterIP(HttpServletRequest request) {
        if (request.getHeader("X-Real-IP") != null) {
            return request.getHeader("X-Real-IP");
        }
        return request.getRemoteAddr();
    }

    public void destroy() {
    }
}

