package com.xebialabs.deployit.rest.test.api.datasets

import com.google.common.base.Charsets
import com.google.common.io.Files
import com.xebialabs.deployit.rest.test.api.DataSet
import com.xebialabs.deployit.util.GuavaFiles
import com.xebialabs.overthere.local.LocalFile

import java.io.File

object SampleSet extends DataSet {
  def name() = "sample"

  def generateSet(args_unused: List[String] = List()): Unit = {
    val tempDir: File = Files.createTempDir()
    try
      create { c =>
        for (i <- 1 to 10) yield c.environment("env" + i) {
          c.server("server" + i) { _ => () } ::
            Nil
        }

        c.environment("otherEnv") {
          c.server("server_1") { _ => () } ::
            c.server("server_2") { _ => () } ::
            Nil
        }

        val version = "1.0"
        val app1 = c.application("app1")
        app1.setLastVersion(version)
        c.deploymentPackage(version, app1) { dp =>
          c.ear("ear1", dp) { e =>
            e.setFile(LocalFile.valueOf({
              val file: File = new File(tempDir, "ear1.ear")
              file.createNewFile()
              Files.asCharSink(file, Charsets.UTF_8).write("**********")
              file
            }))
          } ::
            Nil
        }
      }
    finally {
      try {
        GuavaFiles.deleteRecursively(tempDir)
      } catch {
        case e: Exception => print(e)
      }
    }
  }
}
