package datasets

import com.xebialabs.deployit.rest.test.api.DataSet
import dsl.{EnvironmentUtils, EarUtils}

object RepositoryPerformanceSet extends DataSet with EarUtils with EnvironmentUtils{

  def name() = "RepositoryPerformanceSet"

  def generateSet(args_unused: List[String]): Unit = {
    create { c =>
      createPackageWithDummyEar(c = c, appName = "PERFORM_APP_100_PACK", nrPackages = 100, packageSize = 2, earName = "dummy.ear")
      createPackageWithDummyEar(c = c, appName = "PERFORM_APP_1000_PACK", nrPackages = 1000, packageSize = 2, earName = "dummy.ear")
      createPackageWithDummyEar(c = c, appName = "PERFORM_APP_10000_PACK", nrPackages = 10000, packageSize = 2, earName = "dummy.ear")
      createPackageWithDummyEar(c = c, appName = "PERFORM_APP_SINGLE", nrPackages = 1, packageSize = 1, earName = "dummy.ear")

      createEnvsWithServers(c, nrEnvs = 1, nrServers = 1, name = "PERFORM_ENV_1SER_100_Steps", kbLog = 1, nrSteps = 100, numberOfBlocks = 1)
      createEnvsWithServers(c, nrEnvs = 1, nrServers = 1, name = "PERFORM_ENV_1SER_1000_Steps", kbLog = 1, nrSteps = 1000, numberOfBlocks = 1)
      createEnvsWithServers(c, nrEnvs = 1, nrServers = 1, name = "PERFORM_ENV_1SER_10000_Steps", kbLog = 1, nrSteps = 10000, numberOfBlocks = 1)
      createEnvsWithServers(c, nrEnvs = 1, nrServers = 100, name = "PERFORM_ENV_100_SERVERS_100_Steps", kbLog = 1, nrSteps = 100, numberOfBlocks = 1)
    }
  }
}
