package dsl

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.repository.RepositoryService

import scala.jdk.CollectionConverters._

trait CiUtils {
  def readCisAsMap(ciIds: List[String], repository: RepositoryService): Map[String, BaseConfigurationItem] =
    repository.read[BaseConfigurationItem](ciIds.asJava, 1, false).asScala.toList
      .groupBy(ci => ci.getId.split("/", 2).last).view.mapValues(_.headOption.orNull).toMap
}
