package com.xebialabs.deployit.plugin.test;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;

public class DummyEarToDummyJeeServerMapper extends MappingAgnosticStepGeneratingMapper<Ear, DummyEarMapping, DummyJeeServer> {

	public DummyEarToDummyJeeServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(Ear newMappingSource, DummyJeeServer newMappingTarget, List<Step> steps) {
		for (int i = 0; i < newMappingTarget.getNumberOfSteps(); i++) {
			steps.add(new TestCreateStep(newMappingTarget));
		}

		List<DummyEarMapping> mappingsOfType = change.getNewRevision().getMappingsOfType(DummyEarMapping.class);
		for (DummyEarMapping eachMapping : mappingsOfType) {
			if (eachMapping.getSource().equals(newMappingSource) && eachMapping.getTarget().equals(newMappingTarget)
			        && StringUtils.isNotBlank(eachMapping.getVirtualHost())) {
				steps.add(new TestVirtualHostStep(newMappingTarget, eachMapping.getVirtualHost()));
			}
		}
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(Ear oldMappingSource, DummyJeeServer oldMappingTarget, List<Step> steps) {
		for (int i = 0; i < oldMappingTarget.getNumberOfSteps(); i++) {
			steps.add(new TestDestroyStep(oldMappingTarget));
		}
	}

}
