/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.onthefly;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public class JarOnTheFly {
    private Map<String, Resource> files = new HashMap<String, Resource>();

    public void addFile(String filename, Resource resource) {
        this.files.put(filename, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File jarFile) throws IOException {
        FileOutputStream jarFileOut = new FileOutputStream(jarFile);
        try {
            JarOutputStream jarOut = new JarOutputStream(jarFileOut);
            try {
                for (Map.Entry<String, Resource> eachFile : this.files.entrySet()) {
                    String filename = eachFile.getKey();
                    Resource resource = eachFile.getValue();
                    jarOut.putNextEntry(new JarEntry(filename));
                    InputStream resourceIn = resource.getInputStream();
                    try {
                        IOUtils.copy((InputStream)resourceIn, (OutputStream)jarOut);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)resourceIn);
                    }
                    jarOut.closeEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)jarOut);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)jarFileOut);
        }
    }

    protected File writeToTemporaryFile(String prefix, String suffix) throws IOException {
        File tempJarFile = File.createTempFile(prefix, suffix);
        tempJarFile.deleteOnExit();
        this.write(tempJarFile);
        return tempJarFile;
    }
}

