package com.xebialabs.deployit.test.support.utils;

import com.xebialabs.deployit.StepExecutionContext;

public class DebugStepExecutionContext implements StepExecutionContext {
	private String lastStepOutput = "";
	private String lastStepError = "";

	public void logOutput(String output) {
		if (output.startsWith(lastStepOutput)) {
			System.err.println(output.substring(lastStepOutput.length()));
		} else {
			System.err.println(output);
		}
		lastStepOutput = output;
	}

	public void logError(String error) {
		if (error.startsWith(lastStepError)) {
			System.err.println(error.substring(lastStepError.length()));
		} else {
			System.err.println(error);
		}
		lastStepError = error;
	}

}
