/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.utils;

import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.junit.Assert;
import org.junit.ComparisonFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunBookTestUtils {
    public static List<Step> assertOneResolutionAndGetItsSteps(Collection<ChangeResolution> resolutions) {
        return RunBookTestUtils.assertResolutionLengthAndGetItsSteps(resolutions, 1);
    }

    public static List<Step> assertResolutionLengthAndGetItsSteps(Collection<ChangeResolution> resolutions, int numberOfResolutions) {
        Assert.assertEquals((long)numberOfResolutions, (long)resolutions.size());
        ArrayList<Step> allSteps = new ArrayList<Step>();
        for (ChangeResolution resolution : resolutions) {
            allSteps.addAll(resolution.getSteps());
        }
        return allSteps;
    }

    public static <T> T assertStepOccursOnce(List<Step> steps, Class<T> stepClass) {
        Collection<T> stepsOfClass = RunBookTestUtils.getStepsOfClass(steps, stepClass);
        Assert.assertEquals((long)1L, (long)stepsOfClass.size());
        return stepsOfClass.iterator().next();
    }

    public static <T> Collection<T> getStepsOfClass(List<Step> steps, Class<T> stepClass) {
        return CollectionUtils.select(steps, (Predicate)RunBookTestUtils.getStepClassPredicate(stepClass));
    }

    public static <T> Predicate getStepClassPredicate(final Class<T> stepClass) {
        return new Predicate(){

            public boolean evaluate(Object input) {
                return input.getClass() == stepClass;
            }
        };
    }

    public static <T> void assertTypeSequence(List<T> items, Class<?> ... classes) {
        if (!RunBookTestUtils.containsTypeSequence(items, classes)) {
            String message = "Actual type sequence does not match expected type sequence";
            String expectedClasses = RunBookTestUtils.classesToString(classes);
            String actualClasses = RunBookTestUtils.itemsClassNamesToString(items);
            throw new ComparisonFailure(message, expectedClasses, actualClasses);
        }
    }

    private static <T> boolean containsTypeSequence(List<T> items, final Class<?> ... types) {
        List filteredItems = (List)CollectionUtils.select(items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                Class<?> objectClass = object.getClass();
                for (Class requiredType : types) {
                    if (!requiredType.isAssignableFrom(objectClass)) continue;
                    return true;
                }
                return false;
            }
        });
        if (filteredItems.size() != types.length) {
            return false;
        }
        for (int i = 0; i < filteredItems.size(); ++i) {
            if (types[i].isAssignableFrom(filteredItems.get(i).getClass())) continue;
            return false;
        }
        return true;
    }

    private static String classesToString(Class<?>[] classes) {
        return ExtendedStringUtils.join(Arrays.asList(classes), (Transformer)new Transformer(){

            public Object transform(Object clazz) {
                return ((Class)clazz).getSimpleName();
            }
        });
    }

    private static String itemsClassNamesToString(List<?> steps) {
        return ExtendedStringUtils.join(steps, (Transformer)new Transformer(){

            public Object transform(Object step) {
                return step.getClass().getSimpleName();
            }
        });
    }
}

