/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.deployment.tester;

import com.xebialabs.deployit.test.support.deployment.tester.DeployedItemTester;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFileContentTester
extends DeployedItemTester {
    public XmlFileContentTester(Map<String, String> testParams) {
        super(testParams);
    }

    @Override
    public boolean testDeployedItem() {
        String contextFilePath = (String)this.testParams.get("filePath");
        String xpathWithValues = (String)this.testParams.get("xpathWithValues");
        File contextFile = new File(contextFilePath);
        if (!contextFile.exists()) {
            System.out.println("File was not found at:" + contextFilePath);
            return false;
        }
        Map<String, String> xpathVsValuesMap = this.parseXPathAndTheirValues(xpathWithValues);
        System.out.println("xpathVsValuesMap:" + xpathVsValuesMap);
        return this.verifyXpathValues(contextFile, xpathVsValuesMap);
    }

    private boolean verifyXpathValues(File contextFile, Map<String, String> xpathVsValuesMap) {
        boolean matched = true;
        try {
            Map.Entry<String, String> eachEntry;
            Document document = this.parseContextFile(contextFile);
            Iterator<Map.Entry<String, String>> i$ = xpathVsValuesMap.entrySet().iterator();
            while (i$.hasNext() && (matched = this.verifyEachXpathValue(document, (eachEntry = i$.next()).getKey(), eachEntry.getValue()))) {
            }
        }
        catch (Exception e) {
            matched = false;
            e.printStackTrace();
        }
        return matched;
    }

    private boolean verifyEachXpathValue(Document document, String expression, String value) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(expression);
        String result = xPathExpression.evaluate(document);
        System.out.println("expected value:" + value + ".");
        System.out.println("value for xpath " + expression + " is:" + result + ".");
        return result.equals(value);
    }

    private Document parseContextFile(File contextFile) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new FileInputStream(contextFile)));
        return doc;
    }

    private Map<String, String> parseXPathAndTheirValues(String xpathWithValues) {
        String[] xpaths;
        HashMap<String, String> xpathVsValuesMap = new HashMap<String, String>();
        for (String eachXpathWithValue : xpaths = xpathWithValues.split(",")) {
            String[] xpathAndValue = eachXpathWithValue.split(":");
            if (xpathAndValue.length != 2) continue;
            xpathVsValuesMap.put(xpathAndValue[0], xpathAndValue[1]);
        }
        return xpathVsValuesMap;
    }
}

