/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.deployment.tester;

import com.xebialabs.deployit.test.support.deployment.tester.DeployedItemTester;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceTester
extends DeployedItemTester {
    public DatasourceTester(Map<String, String> testParams) {
        super(testParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testDeployedItem() {
        boolean testResult = false;
        Connection conn = null;
        ResultSet rs = null;
        String jndiName = (String)this.testParams.get("jndiName");
        if (jndiName == null || jndiName == "") {
            System.out.println("No jndiName specified for the datasourceTester");
            return testResult;
        }
        try {
            Object jndiObject = null;
            jndiObject = this.getJndiObject("java:comp/env/" + jndiName);
            if (jndiObject == null) {
                jndiObject = this.getJndiObject(jndiName);
            }
            DataSource ds = (DataSource)jndiObject;
            conn = ds.getConnection();
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("create table if not exists datasource_test_table ( thevalue varchar(16) )");
            stmt.executeUpdate("insert into datasource_test_table ( thevalue) values ( 'bla' ) ");
            rs = stmt.executeQuery("select count(*) as rowcount from datasource_test_table");
            rs.next();
            int count = rs.getInt("rowcount");
            if (count == 1) {
                testResult = true;
            } else {
                System.out.println("Expected one entry but got:" + count);
            }
            stmt.executeUpdate("drop table datasource_test_table");
            System.out.println("DatasourceTester result:" + testResult);
        }
        catch (Exception exc) {
            System.out.println("DatasourceTester failed!");
            exc.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return testResult;
    }

    private Object getJndiObject(String jndiName) {
        Object jndiObject = null;
        try {
            InitialContext ic = new InitialContext();
            try {
                jndiObject = ic.lookup(jndiName);
            }
            catch (Exception e) {
                System.out.println("nothing was found bounded to :" + jndiName);
            }
        }
        catch (NamingException e1) {
            e1.printStackTrace();
        }
        return jndiObject;
    }
}

