/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test;

import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestWriter {
    static final String CI_NAME = "CI-Name";
    static final String CI_TYPE = "CI-Type";
    static final String CI_VERSION = "CI-Version";
    static final String CI_APPLICATION = "CI-Application";
    static final String DEPLOYIT_PACKAGE_FORMAT_VERSION = "Deployit-Package-Format-Version";
    private Manifest manifest = new Manifest();
    private Map<String, Attributes> entries = this.manifest.getEntries();
    private String CI_PREFIX = "CI-";

    public ManifestWriter(String application, String version) {
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue(DEPLOYIT_PACKAGE_FORMAT_VERSION, "1.2");
        mainAttributes.putValue(CI_APPLICATION, application);
        mainAttributes.putValue(CI_VERSION, version);
    }

    public void addMiddlewareResourceEntry(String entryName, String type, Map<String, String> values) {
        Attributes attributesci = new Attributes();
        attributesci.putValue(CI_TYPE, type);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            attributesci.putValue(this.CI_PREFIX + entry.getKey(), entry.getValue());
        }
        this.entries.put(entryName, attributesci);
    }

    public void addDeployableArtifactEntry(String entryName, String type, Map<String, String> values) {
        Attributes attributesci = new Attributes();
        attributesci.putValue(CI_TYPE, type);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            attributesci.putValue(this.CI_PREFIX + entry.getKey(), entry.getValue());
        }
        this.entries.put(entryName, attributesci);
    }

    public Manifest getManifest() {
        return this.manifest;
    }
}

