/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment.tester;

import com.xebialabs.deployit.test.deployment.tester.DeployedItemTester;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;

public class ConfigFileTester
extends DeployedItemTester {
    public ConfigFileTester(Map<String, String> testParams) {
        super(testParams);
    }

    @Override
    public boolean testDeployedItem() {
        boolean testResult = false;
        String configFilePath = (String)this.testParams.get("configFilePath");
        String configFileContent = (String)this.testParams.get("configFileContent");
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            System.out.println("Config file was not found at:" + configFilePath);
            return false;
        }
        StringBuilder fileContentBuilder = new StringBuilder();
        this.readConfigFileContent(configFile, fileContentBuilder);
        if (fileContentBuilder.toString().equals(configFileContent)) {
            testResult = true;
        }
        return testResult;
    }

    private void readConfigFileContent(File configFile, StringBuilder fileContentBuilder) {
        try {
            BufferedReader is = new BufferedReader(new FileReader(configFile));
            String line = is.readLine();
            while (line != null && line.trim() != "") {
                fileContentBuilder.append(line);
                line = is.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Found IOException while reading config file\n" + e.getMessage());
        }
    }
}

