/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.webapp.builder;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.test.deployment.tester.DeployedItemTester;
import com.xebialabs.deployit.test.webapp.builder.DeployedItemTestServlet;
import com.xebialabs.deployit.test.webapp.builder.WarOnTheFly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class WarBuilder {
    private WarOnTheFly warOnTheFly;
    private Map<String, String> testerNames = Maps.newHashMap();
    List<String> testerDetailsContextParam;
    private static final Logger logger = LoggerFactory.getLogger(WarBuilder.class);

    public WarBuilder(String name) {
        this.warOnTheFly = new WarOnTheFly(name);
        this.testerDetailsContextParam = new ArrayList<String>();
        this.warOnTheFly.addServlet(DeployedItemTestServlet.class);
        this.warOnTheFly.addClass(DeployedItemTester.class);
        this.populateTesterNames();
        logger.debug("Discovered Testers:" + this.testerNames);
    }

    public WarBuilder addTester(String testerShortName, String testName, Map<String, String> testParams) throws ClassNotFoundException {
        String testerFullyQualifiedName = this.testerNames.get(testerShortName);
        this.addClassToWar(testerFullyQualifiedName);
        this.buildTesterDetails(testerFullyQualifiedName, testName, testParams);
        return this;
    }

    public byte[] build() throws IOException {
        this.setTesterClasses();
        return this.warOnTheFly.build();
    }

    private void setTesterClasses() {
        String allTesterDetails = StringUtils.collectionToDelimitedString(this.testerDetailsContextParam, (String)"||");
        logger.info("allTesterDetails:" + allTesterDetails);
        this.warOnTheFly.setTesterClasses(allTesterDetails);
    }

    private void buildTesterDetails(String testerFullyQualifiedName, String testName, Map<String, String> testParams) {
        ArrayList<String> aTesterDetailsList = new ArrayList<String>();
        aTesterDetailsList.add("name=" + testerFullyQualifiedName);
        aTesterDetailsList.add("testName=" + testName);
        for (Map.Entry<String, String> eachTesterParam : testParams.entrySet()) {
            aTesterDetailsList.add(eachTesterParam.getKey() + "=" + eachTesterParam.getValue());
        }
        this.testerDetailsContextParam.add(StringUtils.collectionToDelimitedString(aTesterDetailsList, (String)"|"));
    }

    private void addClassToWar(String testerFullyQualifiedName) throws ClassNotFoundException {
        if (testerFullyQualifiedName != null) {
            Class<?> testerClass = Class.forName(testerFullyQualifiedName);
            this.warOnTheFly.addClass(testerClass);
        }
    }

    private void populateTesterNames() {
        Reflections reflections = new Reflections("com.xebialabs.deployit.test", new Scanner[]{new SubTypesScanner()});
        Set testerClasses = reflections.getSubTypesOf(DeployedItemTester.class);
        logger.info("testerClasses found after reflections:" + testerClasses);
        for (Class each : testerClasses) {
            String fullName = each.getName();
            this.testerNames.put(fullName.substring(fullName.lastIndexOf(".") + 1), fullName);
        }
    }
}

