/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatActiveMQConnectionFactory;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatResourceMapping;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.CreateTomcatActiveMQConnectionFactoryStep;
import com.xebialabs.deployit.plugin.tomcat.step.DestroyTomcatActiveMQConnectionFactoryStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQConnectionFactoryToTomcatServerMapper
extends MappingAgnosticStepGeneratingMapper<TomcatActiveMQConnectionFactory, TomcatResourceMapping, TomcatUnmanagedServer> {
    private Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>[] tomcatServerMappers;

    public ActiveMQConnectionFactoryToTomcatServerMapper(Change<Deployment> change, Mapper<War, TomcatWarMapping, TomcatUnmanagedServer> ... tomcatServerMappers) {
        super(change);
        this.tomcatServerMappers = tomcatServerMappers;
    }

    protected void generateAdditionStepsForAddedMapping(TomcatActiveMQConnectionFactory newMappingSource, TomcatUnmanagedServer newMappingTarget, List<Step> steps) {
        Set<TomcatWarMapping> addedAndModifiedWarMappings = this.getAddedAndModifiedWarMappings();
        for (TomcatWarMapping warMapping : addedAndModifiedWarMappings) {
            if (!((TomcatServer)((Object)warMapping.getTarget())).equals((Object)newMappingTarget)) continue;
            if (!StringUtils.isBlank((String)warMapping.getContextRoot())) {
                steps.add(new CreateTomcatActiveMQConnectionFactoryStep(newMappingTarget, newMappingSource, warMapping));
                continue;
            }
            throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
        }
    }

    protected void generateDeletionStepsForDeletedMapping(TomcatActiveMQConnectionFactory oldMappingSource, TomcatUnmanagedServer oldMappingTarget, List<Step> steps) {
        Set<TomcatWarMapping> deletedAndModifiedMappings = this.getdeletedAndModifiedWarMappings();
        for (TomcatWarMapping warMapping : deletedAndModifiedMappings) {
            if (!((TomcatServer)((Object)warMapping.getTarget())).equals((Object)oldMappingTarget)) continue;
            if (!StringUtils.isBlank((String)warMapping.getContextRoot())) {
                steps.add(new DestroyTomcatActiveMQConnectionFactoryStep(oldMappingTarget, oldMappingSource, warMapping));
                continue;
            }
            throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
        }
    }

    private Set<TomcatWarMapping> getdeletedAndModifiedWarMappings() {
        HashSet<TomcatWarMapping> warMappings = new HashSet<TomcatWarMapping>();
        for (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer> mapper : this.tomcatServerMappers) {
            warMappings.addAll(mapper.getOldMappings());
        }
        return warMappings;
    }

    private Set<TomcatWarMapping> getAddedAndModifiedWarMappings() {
        HashSet<TomcatWarMapping> warMappings = new HashSet<TomcatWarMapping>();
        for (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer> mapper : this.tomcatServerMappers) {
            warMappings.addAll(mapper.getNewMappings());
        }
        return warMappings;
    }
}

