/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeployApplicationStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatUndeployApplicationStep;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarToTomcatUnmanagedServerMapper
extends StepGeneratingMapper<War, TomcatWarMapping, TomcatUnmanagedServer> {
    public WarToTomcatUnmanagedServerMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(War newSource, TomcatWarMapping mapping, TomcatUnmanagedServer newTarget, List<Step> steps) {
        if (this.isAppBaseNeeded(newSource.getName(), mapping.getContextRoot()) && StringUtils.isBlank((String)mapping.getAppBase())) {
            throw new ResolutionException("Server " + newTarget.getLabel() + " appBase must be specified when context root specified is different from war name");
        }
        steps.add(new TomcatDeployApplicationStep(newTarget, mapping));
    }

    protected void generateDeletionStepsForDeletedMapping(War oldSource, TomcatWarMapping mapping, TomcatUnmanagedServer oldTarget, List<Step> steps) {
        steps.add(new TomcatUndeployApplicationStep(oldTarget, mapping));
    }

    private boolean isAppBaseNeeded(String warName, String contextPath) {
        return !StringUtils.isBlank((String)contextPath) && !contextPath.equals(warName);
    }
}

