/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;

@SuppressWarnings("serial")
public class TomcatDeployApplicationStep extends TomcatDeploymentStepBase {

	private static final String FILE_PART_EXTENSION = ".part";
	private boolean exploded = false;

	public TomcatDeployApplicationStep(TomcatUnmanagedServer target, TomcatWarMapping mapping) {
		super(target, mapping);
		setDescription("Deploy WAR file " + mapping.getSource() + " to Tomcat server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = server.connectToAdminHost();
		try {
			HostSession lhs = Host.getLocalHost().getHostSession();
			try {
				HostFile sourceFile = lhs.getFile(artifact.getLocation());

				if (!exploded) {
					HostFile partTargetTmpFile = rhs.getFile(getDeployedArtifactPath() + FILE_PART_EXTENSION);
					ctx.logOutput("Copying application artifact to " + partTargetTmpFile.getPath() + " on " + server.getHost());
					HostFileUtils.copyFile(sourceFile, partTargetTmpFile);

					HostFile targetDeployFile = rhs.getFile(getDeployedArtifactPath());
					ctx.logOutput("Moving application artifact from " + partTargetTmpFile.getPath() + " to " + targetDeployFile.getPath()
							+ " on " + server.getHost());
					partTargetTmpFile.moveTo(targetDeployFile);
				} else {
					String artifactTargetDirName = artifact.getName() + ".tmp";
					HostFile targetTmpDir = rhs.getTempFile(artifactTargetDirName);
					targetTmpDir.mkdirs();
					ctx.logOutput("Unzipping application artifact to " + targetTmpDir.getPath() + " on " + server.getHost());
					HostFileUtils.unzip(sourceFile, targetTmpDir);
					HostFile targetDeployDir = rhs.getFile(getExplodedWarTargetFileName());
					ctx.logOutput("Moving application artifact from " + targetTmpDir.getPath() + " to " + targetDeployDir.getPath()
							+ " on " + server.getHost());
					targetTmpDir.moveTo(targetDeployDir);
				}

				if (isContextSet()) {
					// create the context file
					HostFile contextFile = rhs.getFile(getContextFilePathOnServer());
					TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
					if (!exploded) {
						contextFileUtils.addOrUpdateContextPath(getDeployedArtifactPath());
					} else {
						contextFileUtils.addOrUpdateContextPath(getExplodedWarTargetFileName());
					}

				}

				ctx.logOutput("Done.");
				return true;
			} finally {
				lhs.close();
			}
		} finally {
			rhs.close();
		}
	}

}
