/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

/**
 * A Tomcat JDBC DataSource, based on default DBCP connection pool from the Apache's commons project.
 * 
 */
@SuppressWarnings("serial")
@ConfigurationItem
public class TomcatDataSource extends TomcatResource {

	public static final String TYPE = "javax.sql.DataSource";

	@ConfigurationItemProperty
	private String driverClass;

	@ConfigurationItemProperty(size = Size.LARGE)
	private String connectionUrl;

	@ConfigurationItemProperty
	private String username;

	@ConfigurationItemProperty(password = true)
	private String password;
	
	@ConfigurationItemProperty(description="The maximum number of active instances that can be allocated from this pool at the same time")
	private int maxActive;
	
	@ConfigurationItemProperty(description="The minimum number of connections that can sit idle in this pool at the same time")
	private int minIdle;		

	@ConfigurationItemProperty(description="The maximum number of connections that can sit idle in this pool at the same time")
	private int maxIdle;
	
	@ConfigurationItemProperty(description="The maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception")
	private int maxWait;

	@ConfigurationItemProperty
	private boolean removeAbandoned;

	@ConfigurationItemProperty
	private int removeAbandonedTimeout;

	@ConfigurationItemProperty
	private boolean logAbandoned;

	@ConfigurationItemProperty
	private boolean defaultAutoCommit = false;
	

	public String getDriverClass() {
		return driverClass;
	}

	public void setDriverClass(String driverClass) {
		this.driverClass = driverClass;
	}

	public String getConnectionUrl() {
		return connectionUrl;
	}

	public void setConnectionUrl(String connectionUrl) {
		this.connectionUrl = connectionUrl;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getMaxActive() {
		return maxActive;
	}

	public void setMaxActive(int maxActive) {
		this.maxActive = maxActive;
	}

	public int getMaxIdle() {
		return maxIdle;
	}

	public void setMaxIdle(int maxIdle) {
		this.maxIdle = maxIdle;
	}

	public int getMaxWait() {
		return maxWait;
	}

	public void setMaxWait(int maxWait) {
		this.maxWait = maxWait;
	}

	public int getMinIdle() {
		return minIdle;
	}

	public boolean isRemoveAbandoned() {
		return removeAbandoned;
	}

	public int getRemoveAbandonedTimeout() {
		return removeAbandonedTimeout;
	}

	public boolean isLogAbandoned() {
		return logAbandoned;
	}

	public boolean isDefaultAutoCommit() {
		return defaultAutoCommit;
	}
}
