/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLink;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTomcatResourceLinksStep
extends TomcatStepBase
implements Step {
    private List<ResourceLink> resources;

    public CreateTomcatResourceLinksStep(TomcatServer target, String label, TomcatWarMapping warMapping, List<ResourceLink> resources) {
        super(target, warMapping);
        this.resources = resources;
        this.setDescription("Create Global JNDI Resources based on " + label + " on Tomcat server " + (Object)((Object)this.server) + " on context " + this.contextRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile contextFile = s.getFile(this.getContextFilePathOnServer());
            ctx.logOutput("Creating JNDI Global definitions in context file " + contextFile.getPath() + " on " + this.server.getHost());
            TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
            contextFileUtils.addOrUpdateResources(this.resources);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }

    public List<ResourceLink> getResources() {
        return this.resources;
    }
}

