package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ConfigurationItemProperty;

import java.io.Serializable;

/**
 */
public class ResourceLinkValue implements Serializable {
	@ConfigurationItemProperty
	protected String global;

	@ConfigurationItemProperty
	protected ResourceType type;

	public ResourceLinkValue() {
	}

	public String getGlobal() {
		return global;
	}

	public void setGlobal(String global) {
		this.global = global;
	}

	public ResourceType getType() {
		return type;
	}

	public void setType(ResourceType type) {
		this.type = type;
	}

	public ResourceLinkValue(String global, ResourceType type) {
		this.global = global;
		this.type = type;

	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof ResourceLinkValue)) return false;

		ResourceLinkValue that = (ResourceLinkValue) o;

		if (global != null ? !global.equals(that.global) : that.global != null) return false;
		if (type != that.type) return false;

		return true;
	}

	@Override
	public int hashCode() {
		int result = global != null ? global.hashCode() : 0;
		result = 31 * result + (type != null ? type.hashCode() : 0);
		return result;
	}
}
